#include <LiquidCrystal.h>              // Hier wird eine LCD-Bibliothek in den Hintergrund geladen. Sie vereinfacht das Beschreiben des LCDs.
LiquidCrystal lcd(4, 5, 6, 7, 8, 9);    // Hier werden die Pins am Arduino definiert, die mit dem Display kommunizieren sollen.

float U = 0;                            // Variable für die Spannung
float B = 0;                            // Variable für die magnetische Flussdichte


void setup() {

  lcd.begin(16, 2);                     // Hier wird das Display genauer definiert. Das Display am Shield hat 16 Spalten und 2 Zeilen.   
  
  pinMode (12, OUTPUT);                 // PIN 12 wird als Ausgang definiert. Über den PIN 12 kann später die LCD-Hintergrundbeleuchtung an- und ausgeschaltet werden. 
  digitalWrite (12, HIGH);              // Hintergrundbeleuchtung HIGH = an
  
  pinMode(A0, INPUT);                   // Der analoge PIN 0 wird als Eingang definiert. Am analogen Pin 0 ist die Hallsonde angeschlossen.
                                        // Analoge Pins geben einen Wert von 0 bis 1023 wieder (haben also eine Auflösung von 1024 Schritte). 
                                        // Der Wer ist abhängig von der anliegenden Spannung: 0 = 0V und 1023 = 5V. Entsprechend muss umgerechnet werden
  
  
  }     // Ende Setup


void loop() {
  
  int rohwert = analogRead(A0);         // Der Variablen "rohwert" wird hier der Rohwert zwischen 0 und 1023 zugewiesen, der sich aus der anliegenden Spannung am Pin A0 ergibt.
            
  lcd.clear();                          // Befehl, der alle Positionen auf dem Display löscht.
  lcd.setCursor(0,0);                   // Befehl, der festlegt, wo auf dem Display fortlaufend geschrieben werden soll.
                                        /* Die Klammer ist wie folgt zu deuten: (Spalte,Zeile)
                                           Die Nummerierungen der Spalten und Zeilen fangen bei 0 an. 
                                           (0,0) bedeutet somit, dass ab der Spalte ganz links in der oberen Zeile geschrieben wird. */
  lcd.print("Hallo");                   // Befehl, der festlegt, was auf dem Display geschrieben werden soll. Texte kommen in Anführungszeichen.
  lcd.setCursor(0,1);
  lcd.print ("Welt!");
  delay (500);                          // Eine halbe Sekunde warten. Achtung: Zu schnelles Neubeschreiben des Displays lässt es flackern, ab ca. delay (<60).

}                                       // Ende Loop




/*  P6_Magnetfeldsensor_14.05.2019
 
    **********************************************************
    AUFGABEN (Hinweise und Lösungen finden Sie am Ende!)
    **********************************************************

    1   VORBEREITUNG - Laden Sie dieses Programm unverändert auf den Arduino hoch. Wenn alles geklappt hat, steht "Hallo Welt!" auf dem Display. 


    2   NAME AUF DEM LCD AUSGEBEN - Ändern Sie das Programm so, dass in der oberen Zeile Ihr Vor- und in der unteren Zeile Ihr Nachname steht.
        Ordnen Sie mittels lcd.setCursor() Ihren Namen mittig an.


    3   ROHWERT AUSGEBEN -  Das LCD soll nun den Wert aus der Variablen "rohwert" ausgeben. Variablen werden in lcd.print() ohne Anführungszeichen(!) angegeben.
        Ändern Sie das Programm so, dass auf dem LCD Folgendes ausgegeben wird "Rohwert: <rohwert>" --> d.h. bei einem Rohwert von 512: "Rohwert: 512"


    4   ROHWERT IN SPANNUNG UMRECHNEN UND AUSGEBEN - Lassen Sie den Rohwert in eine Spannung umrechnen mithilfe des folgenden Befehls:   U = (5.0 / 1024.0) * rohwert;  Kopieren Sie den Code an eine geeignete Stelle. 
        Folgendes soll zusätzlich (in der unteren Zeile) auf dem LCD ausgegeben werden "U= <U> V"


    5   SPANNUNG IN MAGNETISCHE FLUSSDICHTE UMRECHNEN UND AUSGEBEN - Die Spannung und die Stärke des Magnetfeldes, in dem sich die Hallsonde befindet, haben einen linearen Zusammenhang.
        Aus den Angaben des Datenblattes (s.a. Begleitblatt) lässt sich folgende Funktion aufstellen:
        B = (666.67 * U - 1666.67);
        B ist eine bereits deklarierte Variable für den Wert der magnetischen Flussdichte.
        Binden Sie diese Formel in das Programm mit ein und lassen Sie das LCD Folgendes ausgeben:
        U = <U> V
        B = <B> Gs


    6   EINHEIT DER MAGNETISCHEN FLUSSDICHTE ÄNDERN - Ändern Sie die Berechnung so, dass die Angabe in der Einheit mT erfolgt. Die Umrechnung ist 1Gs = 0.1mT

        
    7   KALIBRIEREN - Alle Bauteile haben eine mehr oder weniger große Toleranz, die ggf. beachtet werden muss. Dies gilt auch für die Hallsonde, die daher ggf. kalibriert werden muss.
        Die effektive Auflösung der Hallsonde liegt im Bereich von wenigen mT (und kann damit das Erdmagnetfeld nicht registrieren). Hält man sie möglichst weit von magnetischen Einflüssen der Umgebung entfernt, 
        so müsste die von der Hallsonde gemessene magnetische Flussdichte 0 mT betragen. 
        Bei 0mT müsste der Rohwert 512 und somit die Spannung  2.5 V übetragen. 

        Ihr Arduino-Magnetfeldsensor muss kalibriert werden, falls dies nicht der Fall ist. Sollte die Hallsonde trotz fehlender magnetischer Einflüsse einen anderen Wert als 0mT anzeigen, passen Sie demenstprechend Ihre Berechnung an.


    8   LINEAR ODER QUADRATISCH? - Verdeutlichen Sie sich zunächst, wo das Magnetfeld um einen Magneten am stärksten ist. Positionieren Sie einen Magneten vor der Hallsonde und bewegen Sie ihn in gleichen Abständen von ihr weg. 
        Legen Sie z.B. ein Lineal oder Karopapier unter und notieren Sie Werte für Abstand und magnetische Feldstärke. Überprüfen Sie auf diese Weise, ob das Magnetfeld linear oder quadratisch abfällt.


    9   TECHNISCHE ANWENDUNG IM ALLTAG - Einige technische Geräte wie z.B. E-Reader oder Smartphones besitzen die Funktion, dass sie abgeschaltet werden, wenn der Deckel einer Hülle geschlossen wird. 
        Dies wird oftmals über eine Hallsonde und einem Magneten realisiert.
        Stecken Sie die Hallsonde in die dafür vorgesehene Halterung neben dem LCD.
        Simulieren Sie die Klappfunktion, indem Sie die Hintergrundbeleuchtung des LCDs in Abhängigkeit zum Magneten ein- und ausschalten.
        Die Hintergrundbeleuchtung lässt sich über den digitalen Pin 12 steuern.

    
    **********************************************************
    LÖSUNGSHINWEISE
    **********************************************************

    2+3 Ändern Sie lediglich die Texte im vorgegebenen Programm und lassen Sie ggf. die Anführungszeichen weg.

    4   ROHWERT IN SPANNUNG UMRECHNEN UND AUSGEBEN
        - Der Befehl sollte nach der Ermittlung des Rohwertes ins Programm eingebaut werden.
        - Kopieren Sie die Befehle zur Ausgabe des Rohwertes und fügen Sie sie direkt darunter ein. Passen Sie die Position, den Text und die Variable dann an.
        
    6   KALIBRIEREN
        - Schauen Sie sich nochmal den Rohwert an, wenn Sie die Hallsonde möglichst weit von magnetischen Einflüssen entfernt haben.
        - Liegt der Rohwert nicht bei 512, müssen Sie kalibrieren.
        - Sie können bei der Berechnung von U z.B. den Differenzbetrag zu 512 mit dem Rohwert addieren.


    8   TECHNISCHE ANWENDUNG IM ALLTAG
        - Nutzen Sie eine if-else-schleife

        if (U < 3) {
        ... ; 
        }
        else {... ; }

    **********************************************************
    LÖSUNGEN
    **********************************************************
    2   NAME AUF DEM LCD AUSGEBEN - LÖSUNG
    
        void loop(){
          lcd.clear();                
          lcd.setCursor(5,0);                   
          lcd.print("Adriano");
          lcd.setCursor(5,1);
          lcd.print ("Arduino");
          delay (500);
        }  

        
    3   ROHWERT AUSGEBEN - LÖSUNG

        void loop(){
          lcd.clear();                
          lcd.setCursor(0,0);                   
          lcd.print("Rohwert: "); lcd.print (rohwert);
          delay (500);
        }


    4   ROHWERT IN SPANNUNG UMRECHNEN UND AUSGEBEN  - LÖSUNG
        void loop(){
          U = (5.0 / 1024.0) * rohwert;
          lcd.clear();
          lcd.setCursor(0,0);
          lcd.print("U = "); lcd.print(V);
          delay (500);
        }


    5   SPANNUNG IN MAGNETISCHE FLUSSDICHTE UMRECHNEN UND AUSGEBEN  - LÖSUNG
        
        void loop(){
          lcd.clear();
  
          U = (5.0 / 1024.0) * rohwert;
          lcd.setCursor(0,0);
          lcd.print("U = "); lcd.print(U); lcd.print("V");
  
          B = (666.67 * U - 1666.67) / 10;
          lcd.setCursor(0,1);
          lcd.print("B = "); lcd.print(B); lcd.print("mT");
  
          delay (500);
        }


    6   KALIBRIEREN - LÖSUNG
        U = (5.0 / 1024.0) * (rohwert + IHR DIFFERENZBETRAG);


    7   LINEAR ODER QUADRATISCH?  - LÖSUNG
        Messreihe:
        cm     0      1     2     3     4     5
        mT  124,02  27,34 4,88  1,63  0,65  0,33
        Das Magnetfällt fällt nicht linear ab.


    8   TECHNISCHE ANWENDUNG IM ALLTAG - LÖSUNG
        - Fügen Sie Folgendes ins setup() ein:
            
        if (U > 3){
          digitalWrite (12, LOW);}
        else {
          digitalWrite (12, HIGH);}
*/
